#include "Patch.h"
#include "VoltsPerOctave.h"

#include "rings/dsp/resonator.h"
#include "stmlib/dsp/dsp.h"

using namespace rings;

class RingsPatch : public Patch
{
private:
    Resonator resonator;
    VoltsPerOctave hz;
    float sr;
    bool buttonstateA;
public:
    RingsPatch()
    {
        sr = getSampleRate();
        // Initialize the resonator
        resonator.Init();
        // Default params
        resonator.set_frequency(220.0f / sr);   
        resonator.set_structure(0.5f);
        resonator.set_brightness(0.5f);
        resonator.set_damping(0.5f);
        // Set parameter names
        registerParameter(PARAMETER_A, "Pitch");
        registerParameter(PARAMETER_B, "Structure");
        registerParameter(PARAMETER_C, "Brightness");
        registerParameter(PARAMETER_D, "Damping");

        buttonstateA = false;
    }

    void processAudio(AudioBuffer &buffer) override
    {
        float tune = getParameterValue(PARAMETER_A) * 8.0 - 4.0;
        float structure = getParameterValue(PARAMETER_C);
        float brightness = getParameterValue(PARAMETER_D);
        float damping = getParameterValue(PARAMETER_B);

        int size = buffer.getSize();
        FloatArray left = buffer.getSamples(LEFT_CHANNEL);
		FloatArray right = buffer.getSamples(RIGHT_CHANNEL);

        hz.setTune(tune);
        float freq = hz.getFrequency(right[0]);

        resonator.set_frequency(freq / sr);
        resonator.set_structure(structure);
        resonator.set_brightness(brightness);
        resonator.set_damping(damping);

        // If button is pressed then fill the buffer with random values (noise burst)
        if(isButtonPressed(PUSHBUTTON) != buttonstateA){
            buttonstateA = isButtonPressed(PUSHBUTTON);
            if (buttonstateA) {
                left.noise();
                left.multiply(0.5);
            }
        }

        // Read exciter signal from left input buffer
        // Write main output to left output buffer and 
        // the aux output to the right output buffer
        resonator.Process(left.getData(), left.getData(), right.getData(), size);

        left.tanh();
        right.tanh();
    }
};
